#!/bin/bash
# 21.03.2023, file needs executable rights

# Raspberry Pi CM4 test
cat /proc/cpuinfo | grep 'Raspberry Pi Compute Module 4' -q
if [ $? = 0 ]; then
    echo "CM4 model     PASSED"
else
    echo "CM4 model     FAILED, no Raspberry Pi Compute Module 4 detected."
fi

# Raspberry Pi CM4 2-8 GB memory check, is 945.360 kB on 1GB RPi 3B+, is 1.917.108 kB on CM4 2GB
# Check for 1 to 9 GB for the 2-8 GB Raspi versions
cat /proc/meminfo | grep 'MemTotal:[^0-9]*[1-9][0-9][0-9][0-9][0-9][0-9][0-9]' -q
if [ $? = 0 ]; then
    echo "CM4 2-8GB     PASSED"
else
    echo "CM4 2-8GB     FAILED, not detected."
fi

# Raspberry Pi CM4 SDRAM_C voltage test, is 1.2500V on RPi 3B
vcgencmd measure_volts sdram_c | grep '1.1000V' -q
if [ $? = 0 ]; then
    echo "SD_C voltage  PASSED"
else
    echo "SD_C voltage  FAILED, not 1.1000V"
fi

# Raspberry Pi CM4 SDRAM_I voltage test, is 1.2500V on RPi 3B
vcgencmd measure_volts sdram_i | grep '1.1000V' -q
if [ $? = 0 ]; then
    echo "SD_I voltage  PASSED"
else
    echo "SD_I voltage  FAILED, not 1.1000V"
fi

# Raspberry Pi CM4 SDRAM_P voltage test, is 1.2250V on RPi 3B
vcgencmd measure_volts sdram_p | grep '1.1000V' -q
if [ $? = 0 ]; then
    echo "SD_P voltage  PASSED"
else
    echo "SD_P voltage  FAILED, not 1.1000V"
fi

# RTC chip presence test
dmesg | grep rtc0 -q
if [ $? = 0 ]; then
    echo "RTC chip      PASSED"
else
    echo "RTC chip      FAILED, no RTC0 chip detected."
fi

# RTC function test
sudo hwclock --set --date="2023-01-23 12:34"
sudo hwclock -r | grep '2023-01-23 12:34' -q
if [ $? = 0 ]; then
    echo "RTC read      PASSED"
else
    echo "RTC read      FAILED, no time read detected."
fi

# CAN chip MCP2518FD presence test
dmesg | grep 'MCP2518FD' -q
if [ $? = 0 ]; then
    echo "MCP2518FD     PASSED"
else
    echo "MCP2518FD     FAILED, CAN controller not detected."
fi

# CAN test, send message to 0x20 = FMB and listen response
(candump can0 -T 200 | grep "can0  00208000   \[8\]  41 80 12 34 04 00 00 00" -q) &
sleep 0.1
cansend can0 00200000#0407123400
wait $!
if [ $? = 0 ]; then
    echo "CAN           PASSED"
else
    echo "CAN           FAILED, no message detected."
fi

# SNet test, is ttyAMA0
(
	read -n20 -t1 RESP < /dev/serial0
	echo $RESP | grep "SNET Test" -q
) &
sleep 0.1
echo "SNET Test" > /dev/serial0
wait $!
if [ $? = 0 ]; then
	echo "SNet          PASSED"
else
	echo "SNet          FAILED, no message detected."
fi

# 3x Storage test:
dmesg | grep 'mmcblk0: mmc0' -q # µSD0 = boot
if [ $? = 0 ]; then
    echo "MMC0          PASSED"
else
    echo "MMC0          FAILED, no SD0 storage detected."
fi

dmesg | grep 'mmcblk1: mmc1' -q # µSD1
if [ $? = 0 ]; then
    echo "MMC1          PASSED"
else
    echo "MMC1          FAILED, no SD1 storage detected."
fi

dmesg | grep 'Attached SCSI removable disk' -q # USB drive
if [ $? = 0 ]; then
    echo "USB           PASSED"
else
    echo "USB           FAILED, no USB storage detected."
fi

echo "Shutdown in 5s"
sleep 5
sudo poweroff
